/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.script.scriptrun;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.logger.CraftTweakerLogger;
import com.blamejared.crafttweaker.api.zencode.IScriptLoader;
import com.blamejared.crafttweaker.api.zencode.scriptrun.IScriptRun;
import com.blamejared.crafttweaker.api.zencode.scriptrun.IScriptRunInfo;
import com.blamejared.crafttweaker.api.zencode.scriptrun.ScriptRunConfiguration;
import com.blamejared.crafttweaker.impl.preprocessor.PriorityPreprocessor;
import com.blamejared.crafttweaker.impl.script.scriptrun.DecoratedRunKind;
import com.blamejared.crafttweaker.impl.script.scriptrun.PreprocessedSourceFile;
import com.blamejared.crafttweaker.impl.script.scriptrun.RunInfo;
import com.blamejared.crafttweaker.impl.script.scriptrun.ScriptRunLogger;
import com.blamejared.crafttweaker.impl.script.scriptrun.runner.IScriptRunner;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.openzen.zencode.shared.SourceFile;

final class ScriptRun
implements IScriptRun {
    private final List<SourceFile> sources;
    private final RunInfo info;
    private final Consumer<RunInfo> runInfoSetter;
    private final Predicate<IScriptLoader> isFirstRunPredicate;
    private final Consumer<IScriptLoader> actionUndoExecutor;

    ScriptRun(List<SourceFile> sources, RunInfo info, Consumer<RunInfo> runInfoSetter, Predicate<IScriptLoader> isFirstRunPredicate, Consumer<IScriptLoader> actionUndoExecutor) {
        this.sources = sources;
        this.info = info;
        this.runInfoSetter = runInfoSetter;
        this.isFirstRunPredicate = isFirstRunPredicate;
        this.actionUndoExecutor = actionUndoExecutor;
    }

    @Override
    public void execute() throws Throwable {
        IScriptLoader loader = this.info.loader();
        String loaderName = loader.name();
        this.info.isFirstRun(this.isFirstRunPredicate.test(loader));
        try {
            CraftTweakerAPI.LOGGER.info("Started loading scripts for loader '{}'", (Object)loaderName);
            this.undoPreviousRun(loader, this.info.configuration().runKind());
            this.executeRun();
            CraftTweakerAPI.LOGGER.info("Execution for loader '{}' completed successfully", (Object)loaderName);
        }
        catch (Throwable t) {
            CraftTweakerAPI.LOGGER.error("Execution for loader '" + loaderName + "' completed with an error", t);
            throw t;
        }
    }

    @Override
    public IScriptRunInfo specificRunInfo() {
        return this.info;
    }

    private void undoPreviousRun(IScriptLoader loader, ScriptRunConfiguration.RunKind runKind) {
        CraftTweakerLogger.clearPreviousMessages();
        if (runKind != ScriptRunConfiguration.RunKind.EXECUTE) {
            return;
        }
        this.actionUndoExecutor.accept(loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeRun() throws Exception {
        try {
            this.runInfoSetter.accept(this.info);
            ScriptRunLogger logger = new ScriptRunLogger(this::findPriorityIfPresent);
            DecoratedRunKind runKind = DecoratedRunKind.decorate(this.info.configuration().runKind());
            IScriptRunner runner = runKind.runner(this.info, this.sources, logger);
            runner.run();
        }
        finally {
            this.runInfoSetter.accept(null);
        }
    }

    private OptionalInt findPriorityIfPresent(SourceFile file) {
        if (!(file instanceof PreprocessedSourceFile)) {
            return OptionalInt.empty();
        }
        PreprocessedSourceFile preprocessedFile = (PreprocessedSourceFile)file;
        String priority = preprocessedFile.matches().get(PriorityPreprocessor.INSTANCE).get(0).content();
        try {
            return OptionalInt.of(Integer.parseInt(priority));
        }
        catch (NumberFormatException e) {
            return OptionalInt.empty();
        }
    }
}

